unit Unit1;

interface

uses
  SysUtils, Classes, HTTPApp, HTTPProd, DB, ADODB, DSProd, DBWeb,
  Variants; //TADODataSet.Locate

type
  TWebModule1 = class(TWebModule)
    FormPageProducer: TPageProducer;
    AddedPageProducer: TPageProducer;
    ErrorPageProducer: TPageProducer;
    RemovedPageProducer: TPageProducer;
    AboutPageProducer: TPageProducer;
    ADODataSet1: TADODataSet;
    DataSetTableProducer1: TDataSetTableProducer;
    procedure WebModule1PostAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure AddedPageProducerHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
  private
    { Private declarations }
    komunikat :String;
    function ZapiszDoBazy(nazwisko,email,haslo,tytul,opis :String) :Boolean;
    function UsunZBazy(email,haslo :String) :Boolean;
  public
    { Public declarations }
  end;

var
  WebModule1: TWebModule1;

implementation

{$R *.dfm}

procedure TWebModule1.WebModule1PostAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  nazwisko,email,haslo,haslo2,tytul,opis :String;
  email_correct,haslo_zgodne,akcja :Boolean;
begin
email:=Request.ContentFields.Values['email'];
email_correct:=True;
nazwisko:=Request.ContentFields.Values['nazwisko'];
haslo:=Request.ContentFields.Values['haslo'];
haslo2:=Request.ContentFields.Values['haslo2'];
tytul:=Request.ContentFields.Values['tytul'];
opis:=Request.ContentFields.Values['opis'];

if Request.ContentFields.Values['akcja']='dodaj' then akcja:=True
                                                 else akcja:=False;

//Bledy
if Request.ContentFields.Values['nazwisko']='' then komunikat:='Wypenij pole "Imi i nazwisko"';
if Request.ContentFields.Values['tytul']='' then komunikat:='Wypenij pole "Tytu projektu"';
if Request.ContentFields.Values['opis']='' then komunikat:='Wypenij pole "Opis projektu"';

if (Pos('@',email)=0) or (Pos('.',email)=0) then
  begin
  email_correct:=False;
  komunikat:='Zly format e-maila.';
  end;

haslo_zgodne:=((haslo=haslo2) and (haslo<>''));
if not haslo_zgodne then komunikat:='Brak hasla lub potwierdzenie nie jest identyczne';

//Akcja
if akcja then

  begin //dodawanie do listy
  if (Request.ContentFields.Values['nazwisko']<>'')
     and email_correct
     and haslo_zgodne
     and (Request.ContentFields.Values['tytul']<>'')
     and (Request.ContentFields.Values['opis']<>'')
     then //dodawanie do listy, jak sprawdzone
       begin
       if ZapiszDoBazy(nazwisko,email,haslo,tytul,opis)
         then Response.Content:=AddedPageProducer.Content
         else begin
              komunikat:='Identyczny rekord istnieje.';
              Response.Content:=ErrorPageProducer.Content;
              end;
       end
     else //dodawanie do listy, blad danych
       Response.Content:=ErrorPageProducer.Content
  end

   else

   begin //usuwanie z listy
   if email_correct and haslo_zgodne then //usuwanie z listy, email i haslo OK
     begin
     {if not ADODataSet1.Supports([coDelete]) then
       begin
       komunikat:='Baza danych nie obsuguje kasowania rekordw';
       Response.Content:=ErrorPageProducer.Content;
       end
       else
       begin}
       if UsunZBazy(email,haslo)
          then Response.Content:=RemovedPageProducer.Content
          else begin
               komunikat:='W bazie danych nie ma rekordu zawierajcego podany e-mail i haslo';
               Response.Content:=ErrorPageProducer.Content
               end;
       {end;}
     end
     else
     begin
     komunikat:='Niewypenione pole "e-mail" lub brak zgodnoci hasa.';
     Response.Content:=ErrorPageProducer.Content;
     end;
   end;

end;



procedure TWebModule1.AddedPageProducerHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
if TagString='tytul' then ReplaceText:='Jacek Matulewski - Projekty zaliczeniowe';
if TagString='naglowek' then ReplaceText:='Projekty zaliczeniowe';

if TagString='email' then ReplaceText:=Request.ContentFields.Values['email'];
if TagString='nazwisko' then ReplaceText:=Request.ContentFields.Values['nazwisko'];
if TagString='temat' then ReplaceText:=Request.ContentFields.Values['tytul'];

if TagString='komunikat' then ReplaceText:=komunikat;
end;

function TWebModule1.ZapiszDoBazy(nazwisko,email,haslo,tytul,opis :String) :Boolean;
begin
Result:=True;
ADODataSet1.Open;
if ADODataSet1.Locate('email;tytul',VarArrayOf([email,tytul]),[loCaseInsensitive]) then
  begin
  Result:=False;
  Exit;
  end;
ADODataSet1.AppendRecord([nil,nazwisko,email,haslo,tytul,opis]); //nil dla automatycznego identyfikatora
ADODataSet1.Close;
end;


function TWebModule1.UsunZBazy(email,haslo :String) :Boolean;
begin
Result:=False;

{
ADODataSet1.Open;
ADODataSet1.Filtered:=False;
ADODataSet1.Filter:='email = '+QuotedStr(email)+' AND haslo='+QuotedStr(haslo);
ADODataSet1.Filtered:=True;
ADODataSet1.DeleteRecords(arFiltered);
ADODataSet1.Filtered:=False;
ADODataSet1.Close;
}

ADODataSet1.Open;
ADODataSet1.Filter:='email = '+QuotedStr(email)+' AND haslo='+QuotedStr(haslo);
ADODataSet1.Filtered:=True;
while not ADODataSet1.Eof do //jezeli sie powtarzaja
//if not ADODataSet1.Eof then
  begin
  ADODataSet1.Delete;
  Result:=True;
  end;
ADODataSet1.Filtered:=False;
ADODataSet1.Close;

{ADODataSet1.Open;
ADOCommand1.CommandText:='DELETE FROM "Projekty" WHERE email='+QuotedStr(email)+' AND haslo='+QuotedStr(haslo);
ADOCommand1.Execute;
ADODataSet1.Close;}
end;


end.


